//
//		Definition of the main game class
//
#ifndef THE_OVERVIEW_SCENE_H
#define THE_OVERVIEW_SCENE_H


#include "ldwScene.h"
#include "../World/WorldMap.h"
#include "ldwGameWindow.h"
#include "ldwImage.h"
#include "../Effects/FloatingAnim.h"
#include "../Utils/theStringManager.h"

class ldwButton;
class ldwSoundTrack;
class ldwSoundFx;
class theGameState;
class ldwTextControl;
class theRealtimeManager;
class theGraphicsManager;

const int OverviewScene_c_iNumClouds = 5;

#define windInterval 10

class theOverviewScene : public ldwScene
{
public:

	theOverviewScene();
	~theOverviewScene();

	bool HandleKey(int messageId,int keyCode,int character);
	bool HandleMouse(int messageId,ldwPoint location);
	bool HandleMessage(int messageId,long data);
//	bool ForwardWaitingMessage(StringId whichMessage);


protected:

	void Activate(bool active);
	void DrawScene();
	void UpdateScene();
	void DrawUI();

private:

	struct SCloud
	{
		ldwPoint		m_sPos;
		int				m_iSpeed;
	};

	SCloud				m_sCloud[OverviewScene_c_iNumClouds];

	ldwGameWindow 		*gameWindow;
	theGameState  		*gs;
	theGraphicsManager  *gm;
	theStringManager 	*stringMgr;
	theRealtimeManager 	*rtMgr;

	ldwUINT32 secondsTimer;

	ldwUINT32 WINDTIMER;

	bool mZoomingIn;
	bool mZoomingOut;
	float fOpacity;
	int zoomLevel;

	ldwRect fadeInOutRect;
	ldwRect overviewRect;

	const int menuButtonId;
	const int doneButtonId;

	//const int textInputId;

	ldwButton      *menuButton;
	ldwButton	   *doneButton;

	ldwTextControl *sceneLabel;
	ldwTextControl *techLabel;
	ldwTextControl *techField;
	ldwTextControl *popLabel;
	ldwTextControl *popField;
	ldwTextControl *foodLabel;
	ldwTextControl *foodField;

	

};
#endif